/*
 * Decompiled with CFR 0.152.
 */
package rodeo.password.pgencheck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import rodeo.password.pgencheck.AbstractFactory;
import rodeo.password.pgencheck.DefaultUIntGenerator;
import rodeo.password.pgencheck.PasswordData;
import rodeo.password.pgencheck.RandomUIntGenerator;

public final class PasswordMaker
extends PasswordData {
    private final int length;
    private final RandomUIntGenerator randomUIntGenerator;
    private final List<PasswordChar> passwordChars = new ArrayList<PasswordChar>();
    private final List<List<PasswordChar>> groupPasswordChars = new ArrayList<List<PasswordChar>>();

    private PasswordMaker(int length, List<String> charGroups, List<Integer> groupMinCounts, List<Integer> groupMaxCounts, RandomUIntGenerator randomUIntGenerator) {
        super(charGroups, groupMinCounts, groupMaxCounts);
        this.length = length;
        this.randomUIntGenerator = randomUIntGenerator;
        for (int groupIndex = 0; groupIndex < charGroups.size(); ++groupIndex) {
            ArrayList<PasswordChar> pcs = new ArrayList<PasswordChar>();
            for (int codePoint : charGroups.get(groupIndex).codePoints().toArray()) {
                pcs.add(new PasswordChar(codePoint, groupIndex));
            }
            this.passwordChars.addAll(pcs);
            this.groupPasswordChars.add(pcs);
        }
    }

    public static Factory factory() {
        return new Factory();
    }

    public int getLength() {
        return this.length;
    }

    public RandomUIntGenerator getRandomUIntGenerator() {
        return this.randomUIntGenerator;
    }

    public String create() {
        List<PasswordChar> charList = this.passwordChars;
        List<GroupCount> groupCounts = this.initGroupCounts();
        ArrayList<Integer> passwordChars = new ArrayList<Integer>();
        for (int i = 0; i < groupCounts.size(); ++i) {
            for (int j = 0; j < groupCounts.get((int)i).min; ++j) {
                passwordChars.add(this.getRandomCharacter(this.groupPasswordChars.get(i)).getCodePoint());
                ++groupCounts.get((int)i).count;
            }
        }
        while (passwordChars.size() < this.length) {
            PasswordChar pc = this.getRandomCharacter(charList);
            GroupCount groupCount = groupCounts.get(pc.getCharGroupIndex());
            if (groupCount.canAddChar()) {
                passwordChars.add(pc.getCodePoint());
                ++groupCount.count;
                continue;
            }
            charList = this.updateCharacterList(groupCounts);
        }
        Collections.shuffle(passwordChars, this.randomUIntGenerator.random());
        StringBuilder password = new StringBuilder();
        Iterator iterator = passwordChars.iterator();
        while (iterator.hasNext()) {
            int cp = (Integer)iterator.next();
            password.appendCodePoint(cp);
        }
        return password.toString();
    }

    private List<GroupCount> initGroupCounts() {
        ArrayList<GroupCount> groupCounts = new ArrayList<GroupCount>();
        for (int groupIndex = 0; groupIndex < this.charGroups().size(); ++groupIndex) {
            groupCounts.add(new GroupCount(this.groupMinCounts().get(groupIndex), this.groupMaxCounts().get(groupIndex)));
        }
        return groupCounts;
    }

    private PasswordChar getRandomCharacter(List<PasswordChar> passwordChars) {
        return passwordChars.get(this.randomUIntGenerator.getNextUInt(passwordChars.size()));
    }

    private List<PasswordChar> updateCharacterList(List<GroupCount> groupCounts) {
        ArrayList<PasswordChar> passwordChars = new ArrayList<PasswordChar>();
        for (int i = 0; i < groupCounts.size(); ++i) {
            if (!groupCounts.get(i).canAddChar()) continue;
            passwordChars.addAll((Collection<PasswordChar>)this.groupPasswordChars.get(i));
        }
        return passwordChars;
    }

    private static final class PasswordChar {
        private final int codePoint;
        private final int charGroupIndex;

        PasswordChar(int codePoint, int charGroupIndex) {
            this.codePoint = codePoint;
            this.charGroupIndex = charGroupIndex;
        }

        int getCodePoint() {
            return this.codePoint;
        }

        int getCharGroupIndex() {
            return this.charGroupIndex;
        }
    }

    public static final class Factory
    extends AbstractFactory<Factory> {
        private int length = 16;
        private RandomUIntGenerator randomUIntGenerator = DefaultUIntGenerator.GENERATOR;

        private Factory() {
        }

        public Factory setLength(int length) {
            if (length < 1) {
                throw new IllegalArgumentException("Minimum character count must be at least 1. Value received: " + length);
            }
            this.length = length;
            return this;
        }

        public Factory setRandomUIntGenerator(RandomUIntGenerator randomUIntGenerator) {
            this.randomUIntGenerator = randomUIntGenerator;
            return this;
        }

        public PasswordMaker create() {
            if (this.charGroups().isEmpty()) {
                throw new IllegalStateException("At least one charset must be specified before a PasswordMaker can be created");
            }
            if (this.sumOfRequiredCharactersIsGreaterThanPasswordLength()) {
                throw new IllegalStateException("Sum of required characters by type is greater than password length");
            }
            if (this.passwordTooLongForPerCharTypeCountRestrictions()) {
                throw new IllegalStateException("Restrictions on character type counts would prevent a password of length " + this.length + " from being generated");
            }
            return new PasswordMaker(this.length, this.charGroupsCopy(), this.groupMinCountsCopy(), this.groupMaxCountsCopy(), this.randomUIntGenerator);
        }

        private boolean sumOfRequiredCharactersIsGreaterThanPasswordLength() {
            int sum = this.groupMaxCounts().stream().reduce(0, Integer::sum);
            return sum > this.length;
        }

        private boolean passwordTooLongForPerCharTypeCountRestrictions() {
            int sum = 0;
            for (int maxCount : this.groupMaxCounts()) {
                if (maxCount == 0) {
                    return false;
                }
                sum += maxCount;
            }
            return sum < this.length;
        }

        @Override
        Factory getThis() {
            return this;
        }

        @Override
        public Factory addCharGroup(String charGroup) {
            return (Factory)super.addCharGroup(charGroup);
        }

        @Override
        public Factory addCharGroup(String charGroup, int minCount) {
            return (Factory)super.addCharGroup(charGroup, minCount, 0);
        }

        @Override
        public Factory addCharGroup(String charGroup, int minCount, int maxCount) {
            return (Factory)super.addCharGroup(charGroup, minCount, maxCount);
        }

        @Override
        public Factory disallowDuplicateCharacters(boolean disallowDuplicateCharacters) {
            return (Factory)super.disallowDuplicateCharacters(disallowDuplicateCharacters);
        }
    }

    private static class GroupCount {
        final int min;
        final int max;
        int count = 0;

        GroupCount(int min, int max) {
            this.min = min;
            this.max = max;
        }

        boolean canAddChar() {
            return this.max == 0 || this.count < this.max;
        }
    }
}

